/******************************************************
 * Stage module implementation file.                  *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/

#include "nios32_pipe_MEM.H"

inline void nios32_pipe_MEM::nios32_pipe_MEM::behavior()
{
 unsigned ins_id;
 ac_instr_t* instr_vec;

 if (ac_stop_flag)
  return;
 if (is_stalled())
  ctrl.request_update();
 instr_vec = new ac_instr_t(regin->read());
 ins_id = instr_vec->get(IDENT);
 if (ins_id != 0)
 {
  isa.current_instruction_id = ins_id;
  isa._behavior_instruction(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(4));
  switch (ins_id)
  {
   case 1: // add
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_add(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 2: // and1
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_and1(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 3: // andn1
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_andn1(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 4: // asr
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_asr(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 5: // cmp
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_cmp(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 6: // ext16d
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_ext16d(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 7: // ext8d
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_ext8d(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 8: // ld
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_ld(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 9: // lsl
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_lsl(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 10: // lsr
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_lsr(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 11: // mov
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_mov(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 12: // nop
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_nop(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 13: // st
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_st(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 14: // sub
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_sub(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 15: // usr0
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_usr0(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 16: // or1
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_or1(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 17: // xor1
    isa._behavior_nios32_Format_RR(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_xor1(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(2), instr_vec->get(3), instr_vec->get(4));
    break;
   case 18: // addi
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_addi(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 19: // and2
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_and2(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 20: // andn2
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_andn2(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 21: // asri
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_asri(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 22: // bgen
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_bgen(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 23: // cmpi
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_cmpi(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 24: // if0
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_if0(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 25: // if1
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_if1(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 26: // lsli
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_lsli(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 27: // lsri
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_lsri(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 28: // movhi
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_movhi(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 29: // movi
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_movi(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 30: // skp0
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_skp0(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 31: // skp1
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_skp1(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 32: // subi
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_subi(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 33: // or2
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_or2(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 34: // xor2
    isa._behavior_nios32_Format_Ri5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_xor2(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 35: // ldp
    isa._behavior_nios32_Format_RPi5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(8), instr_vec->get(9), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_ldp(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(8), instr_vec->get(9), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 36: // stp
    isa._behavior_nios32_Format_RPi5(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(8), instr_vec->get(9), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_stp(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(8), instr_vec->get(9), instr_vec->get(5), instr_vec->get(3), instr_vec->get(4));
    break;
   case 37: // lds
    isa._behavior_nios32_Format_Ri8(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(12), instr_vec->get(13), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_lds(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(12), instr_vec->get(13), instr_vec->get(3), instr_vec->get(4));
    break;
   case 38: // sts
    isa._behavior_nios32_Format_Ri8(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(12), instr_vec->get(13), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_sts(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(12), instr_vec->get(13), instr_vec->get(3), instr_vec->get(4));
    break;
   case 39: // syscall
    isa._behavior_nios32_Format_Ri8(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(12), instr_vec->get(13), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_syscall(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(12), instr_vec->get(13), instr_vec->get(3), instr_vec->get(4));
    break;
   case 40: // sts16s
    isa._behavior_nios32_Format_i9(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(14), instr_vec->get(15), instr_vec->get(4));
    isa.behavior_sts16s(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(14), instr_vec->get(15), instr_vec->get(4));
    break;
   case 41: // sts8s
    isa._behavior_nios32_Format_i10(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(16), instr_vec->get(4));
    isa.behavior_sts8s(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(16), instr_vec->get(4));
    break;
   case 42: // br
    isa._behavior_nios32_Format_i11(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(10), instr_vec->get(17), instr_vec->get(4));
    isa.behavior_br(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(10), instr_vec->get(17), instr_vec->get(4));
    break;
   case 43: // bsr
    isa._behavior_nios32_Format_i11(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(10), instr_vec->get(17), instr_vec->get(4));
    isa.behavior_bsr(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(10), instr_vec->get(17), instr_vec->get(4));
    break;
   case 44: // pfx
    isa._behavior_nios32_Format_i11(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(10), instr_vec->get(17), instr_vec->get(4));
    isa.behavior_pfx(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(10), instr_vec->get(17), instr_vec->get(4));
    break;
   case 45: // pfxio
    isa._behavior_nios32_Format_i11(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(10), instr_vec->get(17), instr_vec->get(4));
    isa.behavior_pfxio(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(10), instr_vec->get(17), instr_vec->get(4));
    break;
   case 46: // ext16s
    isa._behavior_nios32_Format_Ri1u(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(18), instr_vec->get(19), instr_vec->get(20), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_ext16s(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(18), instr_vec->get(19), instr_vec->get(20), instr_vec->get(3), instr_vec->get(4));
    break;
   case 47: // st16s
    isa._behavior_nios32_Format_Ri1u(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(18), instr_vec->get(19), instr_vec->get(20), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_st16s(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(18), instr_vec->get(19), instr_vec->get(20), instr_vec->get(3), instr_vec->get(4));
    break;
   case 48: // ext8s
    isa._behavior_nios32_Format_Ri2u(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(18), instr_vec->get(21), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_ext8s(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(18), instr_vec->get(21), instr_vec->get(3), instr_vec->get(4));
    break;
   case 49: // st8s
    isa._behavior_nios32_Format_Ri2u(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(18), instr_vec->get(21), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_st8s(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(18), instr_vec->get(21), instr_vec->get(3), instr_vec->get(4));
    break;
   case 50: // save
    isa._behavior_nios32_Format_i8v(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(22), instr_vec->get(23), instr_vec->get(4));
    isa.behavior_save(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(22), instr_vec->get(23), instr_vec->get(4));
    break;
   case 51: // trap
    isa._behavior_nios32_Format_i6v(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(22), instr_vec->get(24), instr_vec->get(25), instr_vec->get(4));
    isa.behavior_trap(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(22), instr_vec->get(24), instr_vec->get(25), instr_vec->get(4));
    break;
   case 52: // abs
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_abs(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 53: // call
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_call(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 54: // fill16
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_fill16(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 55: // fill8
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_fill8(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 56: // ifrnz
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_ifrnz(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 57: // ifrz
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_ifrz(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 58: // jmp
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_jmp(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 59: // lret
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_lret(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 60: // mstep
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_mstep(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 61: // mul
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_mul(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 62: // neg
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_neg(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 63: // not
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_not(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 64: // rdctl
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_rdctl(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 65: // ret
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_ret(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 66: // rlc
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_rlc(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 67: // rrc
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_rrc(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 68: // sext16
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_sext16(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 69: // sext8
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_sext8(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 70: // skprnz
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_skprnz(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 71: // skprz
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_skprz(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 72: // st16d
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_st16d(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 73: // st8d
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_st8d(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 74: // swap
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_swap(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 75: // tret
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_tret(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 76: // usr1
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_usr1(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 77: // usr2
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_usr2(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 78: // usr3
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_usr3(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 79: // usr4
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_usr4(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 80: // wrctl
    isa._behavior_nios32_Format_Rw(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    isa.behavior_wrctl(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(3), instr_vec->get(4));
    break;
   case 81: // ifs
    isa._behavior_nios32_Format_i4w(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(27), instr_vec->get(28), instr_vec->get(4));
    isa.behavior_ifs(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(27), instr_vec->get(28), instr_vec->get(4));
    break;
   case 82: // skps
    isa._behavior_nios32_Format_i4w(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(27), instr_vec->get(28), instr_vec->get(4));
    isa.behavior_skps(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(27), instr_vec->get(28), instr_vec->get(4));
    break;
   case 83: // restore
    isa._behavior_nios32_Format_w(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(29), instr_vec->get(4));
    isa.behavior_restore(static_cast<nios32_parms::ac_stage_list>(id), 0, instr_vec->get(1), instr_vec->get(26), instr_vec->get(29), instr_vec->get(4));
    break;
  }
 }
 regout->write(*instr_vec);
 delete instr_vec;
 done.notify();
 return;
}
